unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ImgList, jpeg, StdCtrls, Buttons, MPlayer;

const
  max7 = 7;
  cRand= 3;

TYPE
  TSpielFeld = ARRAY[1..max7, 1..max7] OF integer;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    ImageList1: TImageList;
    Image1: TImage;
    btnEnde: TButton;
    Panel3: TPanel;
    btnAutomatik: TButton;
    box1: TCheckBox;
    box2: TCheckBox;
    btnNeu: TBitBtn;
    MP1: TMediaPlayer;
    MP2: TMediaPlayer;
    cbxMusik: TCheckBox;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnEndeClick(Sender: TObject);
    procedure btnNeuClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1Click(Sender: TObject);
    procedure btnAutomatikClick(Sender: TObject);
    procedure box1Click(Sender: TObject);
    procedure box2Click(Sender: TObject);
    procedure cbxMusikClick(Sender: TObject);
    procedure MyIdleHandler(Sender: TObject; var Done: Boolean);
    procedure Button1Click(Sender: TObject);

  private
    FStarted  : BOOLEAN;
    FBusy     : BOOLEAN;
    FBmax,
    FHmax     : integer;
    FMouseX,
    FMouseY   : integer;
    FSpielfeld: TSpielFeld;
    FNormal   : integer;
    FRandCol  : integer;
    FPlayer   : integer;  { 1 = Player1 / -1 = Player2; }
    FPlayer1  : integer;
    FPlayer2  : integer;

    PROCEDURE DrawSpiel;
    function  GetZuege(Sp, Zl: integer): integer;
    procedure SetZuege(Sp, Zl: integer; const Value: integer);
    procedure PanelColor;
    function  Setzen(Sp: integer): boolean;
    function  Gewonnen: boolean;
    function  Unentschieden: boolean;
    procedure ComputerZug;
    function  Pruefen(ZielSumme: integer;
                      VAR Spalte: integer): integer;

    function  Probieren(Sp, Spieler: integer;
                        VAR Zl: integer): BOOLEAN;

  public
    property Zug[Sp, Zl: integer]: integer read  GetZuege
                                           write SetZuege;

  end;

var
  Form1: TForm1;

implementation

USES
  Unit2;

{$R *.DFM}

{ TForm1 }

procedure TForm1.DrawSpiel;
VAR
  B,H    : integer;
  sp, zl : integer;

begin
  Image1.Visible := FALSE;
  B := Image1.Width;
  H := Image1.Height;

  WITH Image1.Picture.BitMap DO
  BEGIN
    Width  := B; { Anfangsbreite... }
    Height := H; { ...und Anfangshhe zuweisen }
  END;

  WITH Image1.Canvas do
  BEGIN
    Brush.Color := FRandCol;
    Brush.Style := bsSolid;
    Rectangle(0,0, B,H);
  END;

  for sp := 1 to FBmax
  DO for zl := 1 to FHmax
     do Zug[sp, zl] := Zug[sp, zl];

  Image1.Visible := true;
end; { DrawSpiel }

{ ----- }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Randomize;
  FBmax   := max7;
  FHmax   := max7;
  FNormal := clBlack;
  FPlayer := +1;              { 1 = Player1 / -1 = Player2; }
  FPlayer1:= clRed;
  FPlayer2:= clYellow;
  FRandCol:= clBlue;
  PanelColor;

  MP1.Visible := FALSE;
  MP1.Play;
  Application.OnIdle:= MyIdleHandler;
end;

procedure TForm1.btnEndeClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.btnNeuClick(Sender: TObject);
VAR
  sp, zl : integer;

begin
  IF NOT FStarted THEN
  BEGIN
    DrawSpiel;
    box1.Enabled := TRUE;
    box2.Enabled := TRUE;
    btnAutomatik.Enabled := TRUE;
    FStarted := TRUE;
  END;  

  for zl := 1 TO FHmax
  do for sp := 1 to FBmax do
     begin
       Zug[sp, zl] := 0;
       Application.Processmessages;
       sleep(5)
     end;

  btnAutomatik.Enabled := NOT(box1.Checked AND box2.Checked);
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  IF FStarted
  THEN DrawSpiel;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  FMouseX := X;
  FMouseY := Y;

end;

procedure TForm1.Image1Click(Sender: TObject);
begin
  IF FStarted AND (NOT FBusy)
       AND
     (Image1.Canvas.Pixels[FMouseX, FMouseY] <> FRandCol)
       AND
     (((FPlayer = +1) AND (NOT box1.Checked))
       OR
      ((FPlayer = -1) AND (NOT box2.Checked))) THEN
  BEGIN
    FBusy := TRUE;
    Setzen(FMouseX DIV (Image1.Width DIV FBmax) + 1);
    FBusy := FALSE;
  END;
end;

function TForm1.GetZuege(Sp, Zl: integer): integer;
begin
  Result := FSpielFeld[Sp, Zl];
end;

procedure TForm1.SetZuege(Sp, Zl: integer; const Value: integer);
VAR
  Color  : integer;
  B,H,R  : integer;
  Bx, Hx : integer;
  Bi, Hi : integer;
  X1,Y1,
  X2,Y2  : integer;

begin
  FSpielFeld[Sp, Zl] := Value;

  IF Value = +1
  THEN Color := FPlayer1
  ELSE
    IF Value = -1
    THEN Color := FPlayer2
    ELSE Color := FNormal;;

  R  := cRand;
  B  := Image1.Width;
  H  := Image1.Height;

  Bx := B DIV FBmax;
  Hx := H DIV FHmax;

  WITH Image1.Canvas do
  BEGIN
    Brush.Style := bsSolid;
    Brush.Color := Color;
    Bi := Sp - 1;
    Hi := Zl - 1;
    X1 := Bi * Bx + R;
    Y1 := Hi * Hx + R;
    X2 := Bi * Bx + Bx - R;
    Y2 := Hi * Hx + Hx - R;
    Ellipse(X1,Y1, X2,Y2);
  END;
end;

procedure TForm1.PanelColor;
begin
  IF FPlayer = +1
  THEN Panel2.Color := FPlayer1
  ELSE Panel2.Color := FPlayer2;
end; { PanelColor }

function TForm1.Setzen(Sp: integer): boolean;
VAR
  Zl : integer;

begin
  Zl := 1;
  IF (NOT Gewonnen) AND (Zug[Sp, Zl] = 0) THEN
  BEGIN
    Result := TRUE;
    MP1.FileName := 'Fallen.WAV';
    MP1.Open;
    MP1.Play;
    WHILE Zl <= FHmax DO
    BEGIN
      Zug[Sp, Zl] := FPlayer;
      IF Zl = FHmax
      THEN Break;
      INC(Zl);
      IF Zug[Sp, Zl] = 0 THEN
      BEGIN
        Application.Processmessages;
        Sleep(35);
        Zug[Sp, Zl-1] := 0;
      END
      ELSE
        Break;
    END;

    IF Gewonnen OR Unentschieden THEN
    BEGIN
      btnAutomatik.Enabled := FALSE;
      Zl := 1;
      IF FPlayer = -1
      THEN Zl := 2;
      IF Unentschieden
      THEN
        ShowMessage('Unentschieden')
      ELSE
        ShowMessage('Spieler ' + IntToStr(Zl) + ' hat gewonnen');
    END
    ELSE
    BEGIN
      FPlayer := -FPlayer;
      PanelColor;
    END;
  END
  ELSE
    Result := FALSE;
end;

{ ----- }

function TForm1.Gewonnen: boolean;
VAR
  i1,
  i2,
  i3   : integer;
  Sp,
  Zl   : integer;
  Sum  : integer;

begin
  Result := false;

  FOR i1 := 1 TO FHmax DO
  BEGIN
    FOR i2 := 1 TO FBmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := i2 TO i2 + 3
      DO Sum := Sum + Zug[i3, i1];
      IF ABS(Sum) = 4
      THEN Result := TRUE;
    END;
  END;

  FOR i1 := 1 TO FBmax DO
  BEGIN
    FOR i2 := 1 TO FHmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := i2 TO i2 + 3
      DO Sum := Sum + Zug[i1, i3];
      IF ABS(Sum) = 4
      THEN Result := TRUE;
    END;
  END;

  FOR i1 := 1 TO FHmax - 3 DO
  BEGIN
    FOR i2 := 1 TO FBmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := 0 TO 3 DO
      BEGIN
        Sp := i2 + i3;
        Zl := i1 + i3;
        Sum := Sum + Zug[Sp, Zl];
      END;
      IF ABS(Sum) = 4
      THEN Result := TRUE;
    END;
  END;

  FOR i1 := 1 TO FHmax - 3 DO
  BEGIN
    FOR i2 := FBMax DOWNTO 4 DO
    BEGIN
      Sum := 0;
      FOR i3 := 0 TO 3 DO
      BEGIN
        Sp := i2 - i3;
        Zl := i1 + i3;
        Sum := Sum + Zug[Sp, Zl];
      END;
      IF ABS(Sum) = 4
      THEN Result := TRUE;
    END;
  END;
end; { Gewonnen }

{ ----- }

function TForm1.Unentschieden: boolean;
VAR
  sp : integer;
  
BEGIN
  Result := TRUE;

  for sp := 1 TO FBmax
  do IF Zug[sp, 1] = 0 THEN
     BEGIN
       Result := FALSE;
       Break;
     END;
END; { Unentschieden }

{ ----- }

function TForm1.Pruefen(ZielSumme: integer;
                        VAR Spalte: integer): integer;
VAR
  i1,
  i2,
  i3   : integer;
  Sp,
  Zl   : integer;
  Sum  : integer;

  { --- }

  FUNCTION Summieren(Value: integer): BOOLEAN;
  BEGIN
    Result := ((Value >= 0) AND (ZielSumme > 0))
                OR
              ((Value <= 0) AND (ZielSumme < 0));

    IF Result
    THEN Sum := Sum + Value
    ELSE Sum := 0;
  END; { Summieren }

  { --- }

begin
  Result := 0;

  FOR i1 := 1 TO FHmax DO
  BEGIN
    FOR i2 := 1 TO FBmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := i2 TO i2 + 3
      DO IF NOT Summieren(Zug[i3, i1])
         THEN Break;
      IF Sum = ZielSumme
      THEN Result := Result + Sum;
    END;
  END;

  FOR i1 := 1 TO FBmax DO
  BEGIN
    FOR i2 := 1 TO FHmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := i2 TO i2 + 3
      DO IF NOT Summieren(Zug[i1, i3])
         THEN Break;
      IF Sum = ZielSumme
      THEN Result := Result + Sum;
    END;
  END;

  FOR i1 := 1 TO FHmax - 3 DO
  BEGIN
    FOR i2 := 1 TO FBmax - 3 DO
    BEGIN
      Sum := 0;
      FOR i3 := 0 TO 3 DO
      BEGIN
        Sp := i2 + i3;
        Zl := i1 + i3;
        IF NOT Summieren(Zug[Sp, Zl])
        THEN Break;
      END;
      IF Sum = ZielSumme
      THEN Result := Result + Sum;
    END;
  END;

  FOR i1 := 1 TO FHmax - 3 DO
  BEGIN
    FOR i2 := FBMax DOWNTO 4 DO
    BEGIN
      Sum := 0;
      FOR i3 := 0 TO 3 DO
      BEGIN
        Sp := i2 - i3;
        Zl := i1 + i3;
        IF NOT Summieren(Zug[Sp, Zl])
        THEN Break;
      END;
      IF Sum = ZielSumme
      THEN Result := Result + Sum;
    END;
  END;

  Result := Result DIV ZielSumme;
end; { Pruefen }

{ ----- }

function TForm1.Probieren(Sp, Spieler: integer;
                          var Zl: integer): BOOLEAN;
VAR
  Zi : integer;

begin
  Result := false;

  for Zi := 1 TO FHmax DO
  BEGIN
    IF FSpielFeld[Sp, Zi] = 0 THEN
    BEGIN
      Zl := Zi;
      Result := true;
    END;
  END;

  IF Result
  THEN FSpielFeld[Sp, Zl] := Spieler;
end; { Probieren }

{ ----- }

FUNCTION IntToStrF(Value, Size: integer): string;
BEGIN
  STR(Value: Size, Result);
END; { IntToStrF }

{ ----- }

procedure TForm1.btnAutomatikClick(Sender: TObject);
VAR
  S1, Z1   : integer;
  Sp       : integer;
  Old      : BOOLEAN;
  Summen   : ARRAY[1..4, 2..4, 0..Max7] OF integer;
  Delta    : ARRAY[1..4, 2..4, 1..max7] OF integer;
  Gewichte : ARRAY[1..max7] OF integer;

  Spieler  : STRING;
  aSt      : STRING;

begin
  Old := btnAutomatik.Enabled;
  btnAutomatik.Enabled := FALSE;

  TRY
    IF FPlayer = +1
    THEN Spieler := 'Spieler 1: '
    ELSE Spieler := 'Spieler 2: ';

    FillChar(Summen, SizeOF(Summen), #0);
    FillChar(Delta,  SizeOF(Delta), #0);

    Summen[1, 2, 0] := Pruefen(2*FPlayer, Sp);
    Summen[1, 3, 0] := Pruefen(3*FPlayer, Sp);
    Summen[1, 4, 0] := Pruefen(4*FPlayer, Sp);
    Summen[2, 2, 0] := Pruefen(2*-FPlayer, Sp);
    Summen[2, 3, 0] := Pruefen(3*-FPlayer, Sp);
    Summen[2, 4, 0] := Pruefen(4*-FPlayer, Sp);
    FOR s1 := 2 TO 4 DO
    BEGIN
      Summen[3, s1, 0] := Summen[2, s1, 0];
      Summen[4, s1, 0] := Summen[2, s1, 0];
    END;
    FOR s1 := 1 TO FBmax DO
    BEGIN
      IF Probieren(s1, FPlayer, z1) THEN
      BEGIN
        Summen[1, 2, s1] := Pruefen(2*FPlayer, Sp);
        Summen[1, 3, s1] := Pruefen(3*FPlayer, Sp);
        Summen[1, 4, s1] := Pruefen(4*FPlayer, Sp);
        Summen[2, 2, s1] := Pruefen(2*-FPlayer, Sp);
        Summen[2, 3, s1] := Pruefen(3*-FPlayer, Sp);
        Summen[2, 4, s1] := Pruefen(4*-FPlayer, Sp);
        FSpielfeld[s1,z1] := -FPlayer;       { Was whre wenn ? }
        Summen[3, 2, s1] := Pruefen(2*-FPlayer, Sp);
        Summen[3, 3, s1] := Pruefen(3*-FPlayer, Sp);
        Summen[3, 4, s1] := Pruefen(4*-FPlayer, Sp);
        FSpielfeld[s1,z1] := 0;              { Und zurcksetzen }
        IF z1 > 1 THEN
        BEGIN
          FSpielFeld[s1, z1]   :=  FPlayer;
          FSpielFeld[s1, z1-1] := -FPlayer;
          Summen[4, 2, s1] := Pruefen(2*-FPlayer, Sp);
          Summen[4, 3, s1] := Pruefen(3*-FPlayer, Sp);
          Summen[4, 4, s1] := Pruefen(4*-FPlayer, Sp);
          FSpielFeld[s1, z1]   := 0;
          FSpielFeld[s1, z1-1] := 0;
        END;
      END;
    END;

    for z1 := 2 TO 4 DO
    BEGIN
      FOR Sp := 1 TO 4 DO
      BEGIN
        aSt := '';
        FOR s1 := 0 TO FBmax
        DO aSt := aSt + IntToStrF(Summen[Sp, z1, s1], 4);
        Form2.Memo1.Lines.Add(Spieler + IntToStr(Z1)+ 'er = '
                              +aSt);
      END;
    END;

    for sp := 1 to 4 DO
    BEGIN
      for s1 := 1 TO FBmax
      DO for z1 := 2 to 4 do
         begin
           IF Sp = 2
           THEN Delta[sp, z1, s1] := Summen[sp, z1, 0] - Summen[sp, z1,s1]
           ELSE Delta[sp, z1, s1] := Summen[sp, z1,s1] - Summen[sp, z1, 0];
         end;
    END;

    for z1 := 2 TO 4 DO
    BEGIN
      FOR Sp := 1 TO 3 DO
      BEGIN
        aSt := '';
        FOR s1 := 1 TO FBmax
        DO aSt := aSt + IntToStrF(Delta[Sp, z1, s1], 4);
        Form2.Memo1.Lines.Add('D E L T A: ' + IntToStr(Z1)+ 'er =     '
                              +aSt);
      END;
    END;

    FOR s1 := 1 TO FBmax
    DO Gewichte[s1] := Delta [1, 2, s1] * 1  { 2er bekommen }
                      +Delta [2, 2, s1] * 2  { Vorh. 2er vom Gegner zertpern }
                      +Delta [3, 2, s1] * 1  { mgl. 2er vom Gegner belegen }
                      +Delta [1, 3, s1] * 3  { 3er bekommen }
                      +Delta [2, 3, s1] * 4  { vorh. 3er vom Gegner zertpern }
                      +Delta [3, 3, s1] * 3  { mgl. 3er vom Gegner belegen }
                      -Delta [4, 3, s1] * 2  { wahrsch. Dreier fr Gegner }
                      +Delta [1, 4, s1] * 75 { Einen VIERER bekommt man gerne }
                      +Delta [2, 4, s1] * 15 { vorh. Vierer vom Gegener zertpern (zu spt!) }
                      +Delta [3, 4, s1] * 25 { mgl. Vierer vom Gegner verhindern }
                      -Delta [4, 4, s1] * 25;{ wahrsch. Vierer fr Gegner }

    aSt := '';
    FOR s1 := 1 TO FBmax
    DO aSt := aSt + IntToStrF(Gewichte[s1], 4);
    Form2.Memo1.Lines.Add('Gewichtung:          ' + aSt);

    Form2.Memo1.Lines.Add('');

    z1 := -10000;
    FOR s1 := 1 TO FBmax DO
    BEGIN
      IF (Zug[s1, 1] = 0) AND (Gewichte[s1] > z1)
      THEN z1 := Gewichte[s1];
    END;

    REPEAT
      Sp := RANDOM(FBmax) + 1;
      IF Gewichte[sp] = z1 THEN
      BEGIN
        IF Zug[Sp, 1] = 0 THEN
        BEGIN
          Setzen(Sp);
          Break;
        END;
      END;  
    UNTIL FALSE;

  FINALLY
    btnAutomatik.Enabled := Old;
  END;
end;

procedure TForm1.ComputerZug;
begin
  IF Gewonnen OR Unentschieden
  THEN Exit;
  
  IF ((FPlayer = +1) AND box1.Checked)
       OR
     ((FPlayer = -1) AND box2.Checked) THEN
  BEGIN
    Screen.Cursor := crHourGlass;
    TRY
      Application.ProcessMessages;
      Sleep(250);
      btnAutomatikClick(Self);
    FINALLY
      Screen.Cursor := crDefault;
    END;
  END;
end;

procedure TForm1.box1Click(Sender: TObject);
begin
  btnAutomatik.Enabled := NOT(box1.Checked AND box2.Checked);
end;

procedure TForm1.box2Click(Sender: TObject);
begin
  btnAutomatik.Enabled := NOT(box1.Checked AND box2.Checked);
end;

procedure TForm1.cbxMusikClick(Sender: TObject);
begin
  IF cbxMusik.Checked
  THEN MP2.Play
  ELSE MP2.Stop;
end;

VAR
  IsWorking: BOOLEAN;   

procedure TForm1.MyIdleHandler(Sender: TObject; var Done: Boolean);
begin
  IF MP2.Visible THEN
  BEGIN
    MP2.Visible := FALSE;

    Screen.Cursor := crHourGlass;
    TRY
      MP2.FileName := 'Start.mid';
      MP2.Open;
      IF cbxMusik.Checked
      THEN MP2.Play;
      IsWorking := FALSE;
    FINALLY
      Screen.Cursor := crDefault;
    END;
  END
  ELSE
    IF NOT IsWorking THEN
    BEGIN
      IsWorking := TRUE;
      Computerzug;
      IsWorking := FALSE;
    END;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.Show;
end;

end.
