unit AgentDemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  OleCtrls, AgentObjects_TLB, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    btncancel: TButton;
    MsAgent: TAgent;
    edtSagEs: TEdit;
    btnStart: TButton;
    btnHide: TButton;
    btnShow: TButton;

    procedure FormCreate(Sender: TObject);
    procedure btncancelClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnHideClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnShowClick(Sender: TObject);
    procedure MsAgentHide(Sender: TObject; const CharacterID: WideString;
      Cause: Smallint);
    procedure MsAgentShow(Sender: TObject; const CharacterID: WideString;
      Cause: Smallint);
    procedure MsAgentBalloonShow(Sender: TObject;
      const CharacterID: WideString);

  private
    FCharacter    : IAgentCtlCharacter;
    FRequest      : IAgentCtlRequest;
    FAgentVisible : boolean;

    procedure WaitForAgent;

  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

const
//  AGENT = 'genie';
//  AGENTPATH = '%s\msagent\chars\genie.acs';

//  AGENT = 'robby';
//  AGENTPATH = '%s\msagent\chars\robby.acs';


  AGENT = 'merlin';
  AGENTPATH = '%s\msagent\chars\merlin.acs';


implementation

{$R *.DFM}


FUNCTION GetWinDir: String;
VAR
  Buffer  : ARRAY [0..MAX_PATH]  OF CHAR;

BEGIN
  Result := '';

  IF GetWindowsDirectory(Buffer, SizeOF(Buffer)) > 0
  THEN Result := Buffer;
END; { GetWinDir }

{ ----- }


procedure TForm1.FormCreate(Sender: TObject);
var
  FullPath : string;

begin
  MsAgent.Connected := true;
  FullPath := Format(AGENTPATH, [GetWinDir]);
  FRequest := MsAgent.Characters.Load(AGENT, FullPath);
  FCharacter := MSAgent.Characters.Character(AGENT);
end; { FormCreate }

{ ----- }

procedure TForm1.btncancelClick(Sender: TObject);
begin
  Close;
end; { btncancelClick }

{ ----- }

procedure TForm1.btnStartClick(Sender: TObject);
begin
  IF NOT FAgentVisible
  THEN btnShowClick(Sender);

  FRequest := FCharacter.Speak(edtSagEs.Text, EmptyParam);
  WaitForAgent;                   { Warten bis der Agent zuende gequatscht hat }
  FCharacter.Play('RestPose');
  WaitForAgent;                   { Warten bis der Agent zuende gequatscht hat }
end; { btnStartClick }

{ ----- }

procedure TForm1.WaitForAgent;
var
  Status : LongInt;

begin
  repeat
    Application.ProcessMessages;
    Status := FRequest.Get_Status;
  until (status <> 2) and (status <> 4);
end; { WaitForAgent }

{ ----- }

procedure TForm1.btnHideClick(Sender: TObject);
begin
  FAgentVisible := false;
  FCharacter.Balloon.Visible := false;
  FCharacter.Hide(false);
  WaitForAgent;
end; { btnHideClick }

{ ----- }

procedure TForm1.FormDestroy(Sender: TObject);
begin
  IF Assigned(FCharacter) THEN
  BEGIN
    FCharacter.StopAll('');
    btnHideClick(Self);
    MsAgent.Characters.UnLoad(AGENT);
  END;
  MsAgent.Connected := false;
end; { FormDestroy }

{ ----- }

procedure TForm1.btnShowClick(Sender: TObject);
begin
  FCharacter.Balloon.Visible := false;
  FRequest := FCharacter.Show(false);
  WaitForAgent;                      { Warten bis der Agent sich angezeigt hat }

  FRequest := FCharacter.MoveTo(Left + Width DIV 3, Top + Height DIV 3, 1200);
  WaitForAgent;             { Warten bis der Agent seine Position erreicht hat }


  FCharacter.Play('GetAttention');
  Sleep(100);
  FCharacter.Play('GetAttention');
  Sleep(100);
  FCharacter.Play('GetAttention');
  Sleep(100);

  FCharacter.Play('Announce');
  WaitForAgent;

  FCharacter.Play('Wave');
  WaitForAgent;

  FCharacter.Play('Greet');
  WaitForAgent;

  FCharacter.Play('Write');
  WaitForAgent;
end;

{ ----- }

procedure TForm1.MsAgentHide(Sender: TObject; const CharacterID: WideString; Cause: Smallint);
begin
  FAgentVisible := false;
end; { MsAgentHide }

{ ----- }

procedure TForm1.MsAgentShow(Sender: TObject;
  const CharacterID: WideString; Cause: Smallint);
begin
  FAgentVisible := true;
end; { MsAgentShow }

{ ----- }

procedure TForm1.MsAgentBalloonShow(Sender: TObject; const CharacterID: WideString);
begin
  FCharacter.Balloon.Visible := true;
end; { MsAgentBalloonShow }

{ ----- }

end.
